/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.object.entity.pathfinding.raycoms;

import net.minecraft.class_2338;
import net.minecraft.class_2540;

public class MNode
implements Comparable<MNode> {
    private static final int HASH_A = 12;
    private static final int HASH_B = 20;
    private static final int HASH_C = 24;
    public final class_2338 pos;
    private final int hash;
    public MNode parent;
    private int counterAdded;
    private int counterVisited;
    private int steps;
    private double cost;
    private double heuristic;
    private double score;
    private boolean closed = false;
    private boolean ladder = false;
    private boolean swimming = false;
    private boolean isOnRails = false;
    private boolean isCornerNode = false;
    private boolean isReachedByWorker = false;

    public MNode(class_2338 pos, double heuristic) {
        this(null, pos, 0.0, heuristic, heuristic);
    }

    public MNode(MNode parent, class_2338 pos, double cost, double heuristic, double score) {
        this.parent = parent;
        this.pos = pos;
        this.steps = parent == null ? 0 : parent.steps + 1;
        this.cost = cost;
        this.heuristic = heuristic;
        this.score = score;
        this.hash = pos.method_10263() ^ (pos.method_10260() << 12 | pos.method_10260() >> 20) ^ pos.method_10264() << 24;
    }

    public MNode(class_2540 byteBuf) {
        if (byteBuf.readBoolean()) {
            this.parent = new MNode(byteBuf.method_10811(), 0.0);
        }
        this.pos = byteBuf.method_10811();
        this.cost = byteBuf.readDouble();
        this.heuristic = byteBuf.readDouble();
        this.score = byteBuf.readDouble();
        this.hash = this.pos.method_10263() ^ (this.pos.method_10260() << 12 | this.pos.method_10260() >> 20) ^ this.pos.method_10264() << 24;
        this.isReachedByWorker = byteBuf.readBoolean();
    }

    public void serializeToBuf(class_2540 byteBuf) {
        byteBuf.writeBoolean(this.parent != null);
        if (this.parent != null) {
            byteBuf.method_10807(this.parent.pos);
        }
        byteBuf.method_10807(this.pos);
        byteBuf.writeDouble(this.cost);
        byteBuf.writeDouble(this.heuristic);
        byteBuf.writeDouble(this.score);
        byteBuf.writeBoolean(this.isReachedByWorker);
    }

    @Override
    public int compareTo(MNode o) {
        if (this.score < o.score) {
            return -1;
        }
        if (this.score > o.score) {
            return 1;
        }
        if (this.heuristic < o.heuristic) {
            return -1;
        }
        if (this.heuristic > o.heuristic) {
            return 1;
        }
        return this.counterAdded - o.counterAdded;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass() == this.getClass()) {
            MNode other = (MNode)o;
            return this.pos.method_10263() == other.pos.method_10263() && this.pos.method_10264() == other.pos.method_10264() && this.pos.method_10260() == other.pos.method_10260();
        }
        return false;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isLadder() {
        return this.ladder;
    }

    public boolean isSwimming() {
        return this.swimming;
    }

    public void setClosed() {
        this.closed = true;
    }

    public int getCounterVisited() {
        return this.counterVisited;
    }

    public void setCounterVisited(int counterVisited) {
        this.counterVisited = counterVisited;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public double getCost() {
        return this.cost;
    }

    public void setCost(double cost) {
        this.cost = cost;
    }

    public int getSteps() {
        return this.steps;
    }

    public void setSteps(int steps) {
        this.steps = steps;
    }

    public void setLadder() {
        this.ladder = true;
    }

    public void setSwimming() {
        this.swimming = true;
    }

    public double getHeuristic() {
        return this.heuristic;
    }

    public void setHeuristic(double heuristic) {
        this.heuristic = heuristic;
    }

    public int getCounterAdded() {
        return this.counterAdded;
    }

    public void setCounterAdded(int counterAdded) {
        this.counterAdded = counterAdded;
    }

    public boolean isOnRails() {
        return this.isOnRails;
    }

    public void setOnRails(boolean isOnRails) {
        this.isOnRails = isOnRails;
    }

    public boolean isReachedByWorker() {
        return this.isReachedByWorker;
    }

    public void setReachedByWorker(boolean bool) {
        this.isReachedByWorker = bool;
    }

    public boolean isCornerNode() {
        return this.isCornerNode;
    }

    public void setCornerNode(boolean isCornerNode) {
        this.isCornerNode = isCornerNode;
    }
}

